/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.command;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.simibubi.create.Create;
import com.simibubi.create.content.logistics.trains.GlobalRailwayManager;
import com.simibubi.create.content.logistics.trains.TrackGraph;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.EdgePointType;
import com.simibubi.create.content.logistics.trains.management.edgePoint.signal.SignalBoundary;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleRuntime;
import com.simibubi.create.foundation.utility.Components;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3218;
import net.minecraft.class_3532;

public class DumpRailwaysCommand {
    static ArgumentBuilder<class_2168, ?> register() {
        return ((LiteralArgumentBuilder)class_2170.method_9247((String)"trains").requires(cs -> cs.method_9259(2))).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            DumpRailwaysCommand.fillReport(source.method_9225(), source.method_9222(), (s, f) -> source.method_9226((class_2561)Components.literal(s).method_27694(st -> st.method_36139(f.intValue())), false), c -> source.method_9226(c, false));
            return 1;
        });
    }

    static void fillReport(class_3218 level, class_243 location, BiConsumer<String, Integer> chat, Consumer<class_2561> chatRaw) {
        GlobalRailwayManager railways = Create.RAILWAYS;
        int white = class_124.field_1068.method_532();
        int blue = 13885148;
        int darkBlue = 9611709;
        int bright = 0xFFEFEF;
        int orange = 16756064;
        chat.accept("", white);
        chat.accept("-+------<< Train Summary: >>------+-", white);
        int graphCount = railways.trackNetworks.size();
        chat.accept("Track Networks: " + graphCount, blue);
        chat.accept("Signal Groups: " + railways.signalEdgeGroups.size(), blue);
        int trainCount = railways.trains.size();
        chat.accept("Trains: " + trainCount, blue);
        chat.accept("", white);
        List<TrackGraph> nearest = railways.trackNetworks.values().stream().sorted((tg1, tg2) -> Float.compare(tg1.distanceToLocationSqr((class_1937)level, location), tg2.distanceToLocationSqr((class_1937)level, location))).limit(5L).toList();
        if (graphCount > 0) {
            chat.accept("Nearest Graphs: ", orange);
            chat.accept("", white);
            for (TrackGraph graph : nearest) {
                Collection<GlobalStation> stations;
                chat.accept(graph.id.toString().substring(0, 5) + " with " + graph.getNodes().size() + " Nodes", white);
                Collection<SignalBoundary> signals = graph.getPoints(EdgePointType.SIGNAL);
                if (!signals.isEmpty()) {
                    chat.accept(" -> " + signals.size() + " Signals", blue);
                }
                if ((stations = graph.getPoints(EdgePointType.STATION)).isEmpty()) continue;
                chat.accept(" -> " + stations.size() + " Stations", blue);
            }
            chat.accept("", white);
            if (graphCount > 5) {
                chat.accept("[...]", white);
                chat.accept("", white);
            }
        }
        List<Train> nearestTrains = railways.trains.values().stream().sorted((t1, t2) -> Float.compare(t1.distanceToLocationSqr((class_1937)level, location), t2.distanceToLocationSqr((class_1937)level, location))).limit(5L).toList();
        if (trainCount > 0 && !nearestTrains.isEmpty()) {
            chat.accept("Nearest Trains: ", orange);
            chat.accept("", white);
            for (Train train : nearestTrains) {
                GlobalStation currentStation;
                chat.accept(train.id.toString().substring(0, 5) + ": " + train.name.getString() + ", " + train.carriages.size() + " Wagons", bright);
                if (train.derailed) {
                    chat.accept(" -> Derailed", orange);
                } else if (train.graph != null) {
                    chat.accept(" -> On Track: " + train.graph.id.toString().substring(0, 5), blue);
                }
                class_1309 owner = train.getOwner((class_1937)level);
                if (owner != null) {
                    chat.accept(" -> Owned by " + owner.method_5477().getString(), blue);
                }
                if ((currentStation = train.getCurrentStation()) != null) {
                    chat.accept(" -> Waiting at: " + currentStation.name, blue);
                } else if (train.navigation.destination != null) {
                    chat.accept(" -> Travelling to " + train.navigation.destination.name + " (" + class_3532.method_15357((double)train.navigation.distanceToDestination) + "m away)", darkBlue);
                }
                ScheduleRuntime runtime = train.runtime;
                if (runtime.getSchedule() != null) {
                    chat.accept(" -> Schedule, Entry " + runtime.currentEntry + ", " + (runtime.paused ? "Paused" : runtime.state.name().replaceAll("_", " ")), runtime.paused ? darkBlue : blue);
                } else {
                    chat.accept(" -> Idle, No Schedule", darkBlue);
                }
                chatRaw.accept(DumpRailwaysCommand.createDeleteButton(train));
                chat.accept("", white);
            }
            if (trainCount > 5) {
                chat.accept("[...]", white);
                chat.accept("", white);
            }
        }
        chat.accept("-+--------------------------------+-", white);
    }

    private static class_2561 createDeleteButton(Train train) {
        return class_2564.method_10885((class_2561)Components.literal("Remove").method_27694(p_180514_ -> p_180514_.method_36139(16756064).method_10958(new class_2558(class_2558.class_2559.field_11750, "/c killTrain " + train.id.toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)Components.literal("Click to remove ").method_10852(train.name))).method_10975("/c killTrain " + train.id.toString())));
    }
}

